@foreach (['adult', 'child', 'infant'] as $type)
@if(isset($data[$type]) && $data[$type] > 0)
@for ($index = 0; $index < $data[$type]; $index++)

<div class="mt-3 mt-lg-4">
    <h6 class="my-2">@lang('app.traveler') {{ $index+1 }} (@lang('app.' . $type))</h6>
    <div class="row">
        @php
            $fields = [
                'name' => [
                    'type' => 'text',
                    'label' => 'app.name',
                    'required' => true,
                ],
                'phone' => [
                    'type' => 'tel',
                    'label' => 'app.phone',
                    'required' => false,
                ],
                'date_of_birth' => [
                    'type' => 'date',
                    'label' => 'user.date-of-birth',
                    'required' => true,
                    'min' => $type === 'adult' ? now()->subYears(100)->format('Y-m-d') : ($type === 'child' ? now()->subYears(18)->format('Y-m-d') : now()->subYears(2)->format('Y-m-d')),
                    'max' => $type === 'adult' ? now()->subYears(18)->format('Y-m-d') : ($type === 'child' ? now()->subYears(2)->format('Y-m-d') : now()->format('Y-m-d')),
                ]
            ];
        @endphp

        <input type="hidden" name="travelers[{{$type}}][{{ $index }}][type]" value="{{ $type }}">

        @foreach ($fields as $field => $config)
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="{{ $field }}-{{ $type }}-{{ $index }}" class="mt-1 form-label">
                        @lang($config['label']) @if($config['required']) <span class="text-danger">*</span> @endif
                    </label>
                    <input
                        type="{{ $config['type'] }}"
                        class="form-control"
                        name="travelers[{{$type}}][{{ $index }}][{{ $field }}]"
                        id="{{ $field }}-{{ $type }}-{{ $index }}"
                        placeholder="@lang($config['label'])"
                        value="{{ old("travelers.".($type).".".($index).".".$field) }}"
                        @if($config['required']) required @endif
                        @if(isset($config['min'])) min="{{ $config['min'] }}" @endif
                        @if(isset($config['max'])) max="{{ $config['max'] }}" @endif
                    >
                </div>
            </div>
        @endforeach
    </div>
</div>

@endfor
@endif
@endforeach
